IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Cbtes_Rec_Fin') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Cbtes_Rec_Fin 
END
GO

CREATE PROCEDURE [dbo].[CPJ_Cbtes_Rec_Fin] @pJson VARCHAR(8000)
AS
SET NOCOUNT ON

/*Variables recibidas por parßmetro a traves del JSON*/
DECLARE @pFlagUsarTrans					TINYINT
DECLARE @pModoDebug						TINYINT
DECLARE @pId_Trans						INT
DECLARE @pOmitir_Resultado_OK			TINYINT
DECLARE @pFlag_Renumerar				TINYINT

SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Trans					= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Trans')),0)
SET @pOmitir_Resultado_OK		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Omitir_Resultado_OK')),0)
SET @pFlag_Renumerar			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Flag_Renumerar')), 0)
/*FIN Variables recibidas por parßmetro a traves del JSON*/

/*Variable de Retorno del Stored*/
DECLARE @rtaErrorStored						INT
DECLARE @rtaMsjStored						VARCHAR(4000)
DECLARE @JSON_Parametros_Stored_Invocado	VARCHAR(8000)
DECLARE @Result_Stored_Invocado				INT
/*FIN Variable de Retorono del Stored*/

/*Declaracion Variables Locales*/
DECLARE @Id_Cta_Contable		INT
DECLARE @Fecha					DATETIME
DECLARE @Debe					DECIMAL(12,2)
DECLARE @Haber					DECIMAL(12,2)
DECLARE @Observacion			VARCHAR(100)
DECLARE @Alias					SMALLINT
DECLARE @Id_Asiento				INT
DECLARE @Id_Centro_Costo		CHAR(10)
DECLARE @Item					SMALLINT
DECLARE @Resultado				INT
DECLARE @Descripcion_Cbte		VARCHAR(80)
DECLARE @Importe_Aplicado		DECIMAL(16,2)
DECLARE @Importe_Pago_A_Cta		DECIMAL(16,2)
DECLARE @Importe_Rec			DECIMAL(16,2)
DECLARE @Mensaje				VARCHAR(100)
/*Fin de Declaraciones Variables Locales */

BEGIN TRY
	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Cbtes_Rec_Fin'
		PRINT 'Parámetros: '
		PRINT 'FlagUsarTrans: ' + CONVERT(VARCHAR(10), @pFlagUsarTrans) + '. Id_Trans: ' + CONVERT(VARCHAR(10), @pId_Trans) 
	END
	
	IF(@pId_Trans = 0)
	BEGIN
		IF @pOmitir_Resultado_OK = 0
		BEGIN
			SET @rtaErrorStored = 70001 /*Transaccion no abierta*/
			
			SELECT	 @rtaErrorStored	AS ErrorNumber 
					,0					AS ErrorSeverity  
					,0					AS ErrorState 
					,0					AS ErrorProcedure  
					,0					AS ErrorLine		
					,''					AS ErrorMessage
		END
		
		IF @pFlagUsarTrans <> 0 
		BEGIN
			ROLLBACK
		END
		
		RETURN 9999
	END

	SET @Importe_Rec				= ISNULL((SELECT Imp_Total FROM Cbtes WHERE Id_Trans = @pId_Trans),0)
	SET @Importe_Aplicado			= ISNULL((SELECT SUM(Importe) FROM Cbtes_Aplica WHERE Id_Trans_D = @pId_Trans AND Id_Trans <> 0), 0) 
	SET @Importe_Pago_A_Cta			= ISNULL((SELECT SUM(Importe) FROM Cbtes_Aplica WHERE Id_Trans_D = @pId_Trans AND Id_Trans = 0), 0)
	SET @Descripcion_Cbte			= (dbo.CF_Cbte_Descrip(@pId_Trans))

	UPDATE Transacciones SET Descripcion = SUBSTRING((Descripcion + ' ' + @Descripcion_Cbte), 1, 50) WHERE Id_Trans = @pId_Trans

	--------------------------------- ACTUALIZO ESTADOS EN TABLAS DE CBTE ---------------------------------


	UPDATE Valores SET Id_Estado_Valor = 4  WHERE Id_Trans = @pId_Trans
	UPDATE Valores_Mov SET Id_Estado_Valor = 4 WHERE Id_Trans = @pId_Trans
	UPDATE Cajas_Mov SET Id_Estado_Mov_Caja = 2, Descripcion = @Descripcion_Cbte WHERE Id_Trans = @pId_Trans

	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@Importe_Rec: ' + CONVERT(VARCHAR(10), @Importe_Rec) + '. @Importe_Aplicado: ' + CONVERT(VARCHAR(10), @Importe_Aplicado) + '. @Importe_Pago_A_Cta: ' + CONVERT(VARCHAR(10), @Importe_Pago_A_Cta)
	END

	IF(@Importe_Aplicado =  @Importe_Rec)
	BEGIN	
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'Actualiza Estado a COMPLETO'
		END

		UPDATE Cbtes SET Id_Estado_Cbte = 2, Saldo = 0 WHERE Id_Trans = @pId_Trans
		UPDATE Cbtes_Items SET Id_Estado_Cbte = 2 WHERE Id_Trans = @pId_Trans
		UPDATE Clientes_CtaCte SET Id_Estado_Cbte = 2, Descripcion = @Descripcion_Cbte, Saldo = 0 WHERE Id_Trans = @pId_Trans
	END
	ELSE
	BEGIN
		IF(@Importe_Pago_A_Cta = @Importe_Rec)
		BEGIN
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Actualiza Estado a PENDIENTE'
			END

			UPDATE Cbtes SET Id_Estado_Cbte = 1 WHERE Id_Trans = @pId_Trans
			UPDATE Clientes_CtaCte SET Id_Estado_Cbte = 1, Descripcion = @Descripcion_Cbte WHERE Id_Trans = @pId_Trans
		END
		ELSE
		BEGIN
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Actualiza Estado a PARCIAL'
			END

			UPDATE Cbtes SET Id_Estado_Cbte = 4 WHERE Id_Trans = @pId_Trans
			UPDATE Clientes_CtaCte SET Id_Estado_Cbte = 4, Descripcion = @Descripcion_Cbte WHERE Id_Trans = @pId_Trans
		END
	END

	--------------------------------- FIN ACTUALIZO ESTADOS EN TABLAS DE CBTE ---------------------------------

	--------------------------------- GENERACION DE CUENTAS CONTABLES EN CBTE ---------------------------------

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Genero asientos del cbte'
	END

	SET @JSON_Parametros_Stored_Invocado =	'{' +
													dbo.CF_Json_ParsearVariable('FlagUsarTrans', 0, 'TINYINT') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Trans', @pId_Trans, 'TINYINT') + ',' +
													dbo.CF_Json_ParsearVariable('ModoDebug', @pModoDebug, 'INT') + ',' +
													dbo.CF_Json_ParsearVariable('RtaMsjStored', @pOmitir_Resultado_OK, 'TINYINT') + ',' +
													dbo.CF_Json_ParsearVariable('FlagRegenerar', 1, 'TINYINT') + 
											'}'				

	EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Ctas_Contables_Generar @JSON_Parametros_Stored_Invocado
	IF ISNULL(@Result_Stored_Invocado,0) <> 0 
	BEGIN
		RETURN 9999
	END

	--------------------------------- FIN GENERACION DE CUENTAS CONTABLES EN CBTE ---------------------------------

	--------------------------------- ACTUALIZO NUMERACION EN CBTE ---------------------------------

	IF(@pFlag_Renumerar = 1)
	BEGIN
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'Renumero Cbte'
		END

		SET @JSON_Parametros_Stored_Invocado =	'{' +
													dbo.CF_Json_ParsearVariable('FlagUsarTrans', 0, 'TINYINT') + ',' +
													dbo.CF_Json_ParsearVariable('Id_Trans', @pId_Trans, 'TINYINT') + ',' +
													dbo.CF_Json_ParsearVariable('ModoDebug', @pModoDebug, 'INT') + ',' +
													dbo.CF_Json_ParsearVariable('Omitir_Resultado_OK', @pOmitir_Resultado_OK, 'TINYINT') + 
												'}'		

		EXEC @Result_Stored_Invocado = dbo.CPJ_Cbtes_Grabar_Numero @JSON_Parametros_Stored_Invocado
		IF ISNULL(@Result_Stored_Invocado,0) <> 0 
		BEGIN
			RETURN 9999
		END

		SET @Descripcion_Cbte = (dbo.CF_Cbte_Descrip(@pId_Trans))
		UPDATE Transacciones SET Descripcion = @Descripcion_Cbte WHERE Id_Trans = @pId_Trans
		UPDATE Clientes_CtaCte SET Descripcion = @Descripcion_Cbte WHERE Id_Trans = @pId_Trans
	END

	--------------------------------- FIN ACTUALIZO NUMERACION EN CBTE ---------------------------------

	IF @pFlagUsarTrans <> 0 
	BEGIN
		COMMIT
	END

	IF @pOmitir_Resultado_OK = 0
	BEGIN
		SET @rtaMsjStored		=	'{' +
									dbo.CF_Json_ParsearVariable('id_trans', @pId_Trans, 'INT')  + ',' +
									dbo.CF_Json_ParsearVariable('descrip_Cbte', @Descripcion_Cbte, 'VARCHAR') +
									'}'

		SELECT		0						AS ErrorNumber 
					,0						AS ErrorSeverity  
					,0						AS ErrorState 
					,0						AS ErrorProcedure  
					,0						AS ErrorLine		
					,@rtaMsjStored	AS ErrorMessage
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Cbtes_Rec_Fin'
	END
END TRY 
BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0 
	BEGIN
		ROLLBACK
	END

	RETURN 9999
END CATCH

RETURN 0 
